PSCAD 4.2.0

Settings
 {
 Id = "916200857.1144362086"
 Author = "reform.jayas"
 Desc = "VSC transmission"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 5
  Step = 2e-005
  Plot = 0.0001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 255
  Debug = 0
  StartFile = "VSC.snp"
  OFile = "Untitled.out"
  SFile = "VSC.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Component("moduloMR")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Input("Mdl",4,4,120,12,2)
     {
     Desc = "Modulo Factor"
     Data = Real
     Len = 15
     }
    }
   }

  Nodes = 
   {
   Input("in",-54,0)
    {
    Type = Real
    }
   Output("out",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Text(-45,-16,"")
   Pen(,ByNode,,out)
   Line(54,0,29,0)
   Text(0,-10,"Modulo")
   Text(0,12,"%Mdl")
   }

  Section(EMTDC)
   {
   Fortran = "      $out = MOD($in,$Mdl)"
   Branch = ""
   Computations = ""
   }
  }
 Component("PhaseShifter")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   }

  Nodes = 
   {
   Input("in",-54,0)
    {
    Type = Real
    Dim  = [6]
    }
   Output("out",54,0)
    {
    Type = Real
    Dim  = [6]
    }
   Input("phsh",0,54)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode,,out)
   Line(54,0,29,0)
   Text(0,-16,"Shift:")
   Text(0,-3,"(in-sh)")
   Pen(Black,Solid,0.2)
   Line(0,54,0,28)
   Line(-43,3,-37,-3)
   Line(39,3,45,-3)
   Text(43,15,"6")
   Text(-40,16,"6")
   Text(1,22,"sh")
   Text(-21,6,"in")
   }

  Section(EMTDC)
   {
   Fortran = "\
#LOCAL INTEGER i

	DO i=1,6
	  $out(i)=$in(i)-$phsh
	  IF ($out(i).GT.360) $out(i)=$out(i)-360.0
	  IF ($out(i).LT.0.0) $out(i)=$out(i)+360.0
	ENDDO"
   Branch = ""
   Computations = ""
   }
  }
 Component("SinArray")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   }

  Nodes = 
   {
   Input("in",-54,0)
    {
    Type = Real
    Dim  = [6]
    }
   Output("out",54,0)
    {
    Type = Real
    Dim  = [6]
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode,,out)
   Line(54,0,29,0)
   Text(0,-12,"Sin")
   Text(1,9,"Array")
   Pen(Black,Solid,0.2)
   Line(-43,3,-37,-3)
   Line(36,3,42,-3)
   Text(-42,18,"6")
   Text(39,18,"6")
   }

  Section(EMTDC)
   {
   Fortran = "\
#LOCAL INTEGER i
	DO i=1,6
	   $out(i) = SIN(($in(i)/180.0)*PI_)
	ENDDO"
   Branch = ""
   Computations = ""
   }
  }
 Component("MultArray")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   }

  Nodes = 
   {
   Input("in",-54,0)
    {
    Type = Real
    Dim  = [6]
    }
   Output("out",54,0)
    {
    Type = Real
    Dim  = [6]
    }
   Input("mult",0,-54)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode,,out)
   Line(54,0,29,0)
   Pen(,,,mult)
   Line(0,-54,0,-29)
   Pen(,Solid)
   Line(0,-29,-6,-35)
   Line(0,-29,6,-35)
   Text(0,-1,"Multip")
   Pen(Black,,0.2)
   Line(-45,3,-39,-3)
   Line(37,3,43,-3)
   Text(-42,16,"6")
   Text(40,16,"6")
   }

  Section(EMTDC)
   {
   Fortran = "\
#LOCAL INTEGER i
	DO i=1,6
	   $out(i) = $mult * $in(i)
	ENDDO"
   Branch = ""
   Computations = ""
   }
  }
 Module("PQmeas_1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Output("Pow",0,-72)
    {
    Type = Real
    }
   Input("Va",-54,-36)
    {
    Type = Real
    }
   Input("Vb",-54,0)
    {
    Type = Real
    }
   Input("Vc",-54,36)
    {
    Type = Real
    }
   Input("Cax",54,-36)
    {
    Type = Real
    }
   Input("Cbx",54,0)
    {
    Type = Real
    }
   Input("CcX",54,36)
    {
    Type = Real
    }
   Output("Q",0,72)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-47,29,47)
   Text(0,-7,"P&Q")
   Text(0,4,"Meas")
   Pen(ByNode,ByNode,ByNode,Pow)
   Line(0,-72,0,-47)
   Text(7,-59,"P")
   Pen(,,,Va)
   Line(-54,-36,-29,-36)
   Pen(,Solid)
   Line(-29,-36,-35,-29)
   Line(-29,-36,-35,-42)
   Text(-41,-38,"Va")
   Pen(,ByNode,,Vb)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Text(-41,-2,"Vb")
   Pen(,ByNode,,Vc)
   Line(-54,36,-29,36)
   Pen(,Solid)
   Line(-29,36,-35,42)
   Line(-29,36,-35,29)
   Text(-41,33,"Vc")
   Pen(,ByNode,,Cax)
   Line(54,-36,29,-36)
   Pen(,Solid)
   Line(29,-36,35,-29)
   Line(29,-36,35,-42)
   Text(41,-38,"Ca")
   Pen(,ByNode,,Cbx)
   Line(54,0,29,0)
   Pen(,Solid)
   Line(29,0,35,6)
   Line(29,0,35,-6)
   Text(41,-2,"Cb")
   Pen(,ByNode,,CcX)
   Line(54,36,29,36)
   Pen(,Solid)
   Line(29,36,35,42)
   Line(29,36,35,29)
   Text(41,33,"Cc")
   Pen(,ByNode,,Q)
   Line(0,72,0,47)
   Text(7,59,"Q")
   }


  Page(A/A4,Landscape,49,[597,467],100)
   {
   0.import([216,396],0,0,10)
    {
    Name = "Va"
    }
   0.import([342,522],0,0,30)
    {
    Name = "Vb"
    }
   0.import([432,648],0,0,50)
    {
    Name = "Vc"
    }
   0.sumjct([468,396],0,0,110)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.mult([666,396],0,0,120)
    {
    }
   0.sumjct([540,522],0,0,130)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.realpole([1044,522],0,0,190)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "0.0057735"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.export([1188,522],2,0,210)
    {
    Name = "Q"
    }
   -Wire-([252,396],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([378,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([468,522],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([468,648],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([540,648],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.sumjct([630,648],0,0,60)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([270,738],0,0,-1)
    {
    Vertex="0,0;360,0"
    }
   -Wire-([270,738],0,0,-1)
    {
    Vertex="0,0;0,-342"
    }
   -Wire-([630,828],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([504,396],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.import([558,432],0,0,20)
    {
    Name = "Ccx"
    }
   -Wire-([594,432],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.mult([738,522],0,0,140)
    {
    }
   -Wire-([576,522],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.import([630,558],0,0,40)
    {
    Name = "Cax"
    }
   -Wire-([666,558],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.mult([828,648],0,0,150)
    {
    }
   -Wire-([666,648],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.import([720,684],0,0,70)
    {
    Name = "Cbx"
    }
   -Wire-([756,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.sumjct([900,522],0,0,180)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([702,396],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([774,522],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([864,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([900,648],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([900,486],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([936,522],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1080,522],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.mult([720,828],0,0,80)
    {
    }
   0.mult([720,918],0,0,90)
    {
    }
   0.mult([720,1008],0,0,100)
    {
    }
   -Wire-([648,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([630,828],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.sumjct([882,918],0,0,160)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([756,918],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([756,828],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([756,1008],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([882,882],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([882,1008],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.realpole([1008,918],0,0,170)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "0.01"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.export([1152,918],2,0,200)
    {
    Name = "Pow"
    }
   -Wire-([1044,918],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([918,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([648,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([648,954],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([648,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([648,1044],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([648,864],0,0,-1)
    {
    Name = "Cax"
    }
   0.datalabel([648,954],0,0,-1)
    {
    Name = "Cbx"
    }
   0.datalabel([648,1044],0,0,-1)
    {
    Name = "Ccx"
    }
   0.datalabel([648,918],0,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([648,1008],0,0,-1)
    {
    Name = "Vc"
    }
   }
  }
 Module("GainAdjust")
  {
  Desc = ""
  FileDate = 1144362028
  Nodes = 
   {
   Input("X1",-54,0)
    {
    Type = Real
    }
   Output("O1",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Text(0,-15,"Freq Dep")
   Pen(ByNode,ByNode,ByNode,X1)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Text(-42,-3,"X1")
   Pen(,ByNode,,O1)
   Line(54,0,29,0)
   Text(42,-3,"O1")
   Text(0,1,"Gain")
   Text(0,18,"Control")
   }


  Page(A/A4,Landscape,49,[597,467],100)
   {
   0.import([234,666],0,0,10)
    {
    Name = "X1"
    }
   0.rms-inst([342,774],0,0,40)
    {
    Type = "0"
    Ts = "0.5 [s]"
    Scale = "1.0"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.realpole([414,666],0,0,20)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.2 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([270,666],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([450,666],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([306,666],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([720,702],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.rms-inst([594,666],0,0,30)
    {
    Type = "0"
    Ts = "0.5 [s]"
    Scale = "1.0"
    freq = "60.0 [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   0.div([720,666],0,0,80)
    {
    }
   0.maxmin([522,774],0,0,70)
    {
    DPath = "1"
    Type = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "1"
    F = "0"
    G = "0"
    }
   -Wire-([378,774],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([630,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([558,774],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([756,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.realpole([846,666],0,0,90)
    {
    Limit = "1"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "3.33"
    T = "0.2 [s]"
    Max = "1.667"
    Min = "0.667"
    }
   0.export([1098,666],2,0,110)
    {
    Name = "O1"
    }
   -Wire-([882,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.const([450,810],0,0,60)
    {
    Name = ""
    Value = "0.001"
    }
   0.sumjct([972,666],0,0,100)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([1008,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.const([972,738],3,0,50)
    {
    Name = ""
    Value = "0.667"
    }
   }
  }
 Module("Damping")
  {
  Desc = ""
  FileDate = 1144362028
  Nodes = 
   {
   Input("F",-54,0)
    {
    Type = Real
    }
   Output("dF",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Text(0,-1,"DerivP")
   Pen(ByNode,ByNode,ByNode,F)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Text(-42,-3,"F")
   Pen(,ByNode,,dF)
   Line(54,0,29,0)
   Text(42,-3,"dF")
   }


  Page(B/A3,Landscape,49,[597,467],100)
   {
   0.tdelay([270,954],0,0,20)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   0.tdelay([342,918],0,0,40)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   0.tdelay([414,882],0,0,70)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   0.tdelay([486,846],0,0,100)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   0.sumjct([306,576],0,0,30)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([234,954],0,0,-1)
    {
    Vertex="0,0;0,-378"
    }
   -Wire-([306,954],0,0,-1)
    {
    Vertex="0,0;0,-342"
    }
   -Wire-([144,810],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([234,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([378,702],0,0,50)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([378,918],0,0,-1)
    {
    Vertex="0,0;0,-180"
    }
   -Wire-([306,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([450,756],0,0,80)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([450,882],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([450,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([522,810],0,0,110)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([306,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([378,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([450,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([522,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([540,846],0,0,-1)
    {
    Name = "Z1"
    }
   0.datalabel([468,882],0,0,-1)
    {
    Name = "Z2"
    }
   0.datalabel([396,918],0,0,-1)
    {
    Name = "Z3"
    }
   0.datalabel([324,954],0,0,-1)
    {
    Name = "Z4"
    }
   -Wire-([558,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([486,756],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([414,702],0,0,-1)
    {
    Vertex="0,0;252,0"
    }
   -Wire-([342,576],0,0,-1)
    {
    Vertex="0,0;522,0"
    }
   0.datalabel([576,810],0,0,-1)
    {
    Name = "Z2_Z1"
    }
   0.datalabel([576,756],0,0,-1)
    {
    Name = "Z3_Z2"
    }
   0.datalabel([486,702],0,0,-1)
    {
    Name = "Z3_Z4"
    }
   0.datalabel([396,576],0,0,-1)
    {
    Name = "Z5_Z4"
    }
   0.sumjct([630,810],0,0,120)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "-1-1"
    E = "0"
    F = "0"
    G = "0"
    }
   -Wire-([630,756],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([666,702],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([702,576],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([900,612],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([738,810],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([1026,666],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([666,810],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.sumjct([666,756],0,0,90)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "-1-1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.sumjct([702,702],0,0,60)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "-1-1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.sumjct([864,612],0,0,150)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   0.tdelay([990,666],0,0,160)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   -Wire-([918,612],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.sumjct([1026,612],0,0,170)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.gain([1098,612],0,0,180)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.sumjct([738,756],0,0,130)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1-1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([738,720],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.gain([810,756],0,0,140)
    {
    G = "0.333333"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([846,756],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,648],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([918,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1134,612],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.import([108,810],0,0,10)
    {
    Name = "F"
    }
   0.export([2214,612],2,0,360)
    {
    Name = "dF"
    }
   0.tdelay([1242,954],0,0,190)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   0.tdelay([1314,918],0,0,200)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   0.tdelay([1386,882],0,0,210)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   0.tdelay([1458,846],0,0,250)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   0.sumjct([1278,576],0,0,240)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([1206,954],0,0,-1)
    {
    Vertex="0,0;0,-378"
    }
   -Wire-([1278,954],0,0,-1)
    {
    Vertex="0,0;0,-342"
    }
   -Wire-([1206,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([1350,702],0,0,230)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([1350,918],0,0,-1)
    {
    Vertex="0,0;0,-180"
    }
   -Wire-([1278,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([1422,756],0,0,220)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([1422,882],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   -Wire-([1422,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([1494,810],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([1278,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1350,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1422,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1494,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1530,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,756],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([1386,702],0,0,-1)
    {
    Vertex="0,0;252,0"
    }
   -Wire-([1314,576],0,0,-1)
    {
    Vertex="0,0;522,0"
    }
   0.sumjct([1602,810],0,0,290)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "-1-1"
    E = "0"
    F = "0"
    G = "0"
    }
   -Wire-([1602,756],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1638,702],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1674,576],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Wire-([1872,612],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1710,810],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([1998,666],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([1638,810],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.sumjct([1638,756],0,0,270)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "-1-1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.sumjct([1674,702],0,0,280)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "-1-1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.sumjct([1836,612],0,0,320)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   0.tdelay([1962,666],0,0,330)
    {
    T = "0.05 [s]"
    N = "25"
    Intp = "0"
    COM = "Delay"
    }
   -Wire-([1890,612],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.sumjct([1998,612],0,0,340)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.gain([2070,612],0,0,350)
    {
    G = "0.5"
    COM = "Gain"
    Dim = "1"
    }
   0.sumjct([1710,756],0,0,300)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1-1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([1710,720],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.gain([1782,756],0,0,310)
    {
    G = "0.333333"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([1818,756],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1836,648],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1890,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,612],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   }
  }
 Module("RECtrl")
  {
  Desc = ""
  FileDate = 1144362028
  Nodes = 
   {
   Input("Vinv",-54,-36)
    {
    Type = Real
    Dim  = [3]
    }
   Input("mi",-54,0)
    {
    Type = Real
    }
   Input("dcVltgI",-54,36)
    {
    Type = Real
    }
   Output("g1",54,-90)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g2",54,-54)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g3",54,-18)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g4",54,18)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g5",54,54)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g6",54,90)
    {
    Type = Real
    Dim  = [2]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-111,39,111)
   Pen(ByNode,ByNode,ByNode,Vinv)
   Line(-54,-36,-39,-36)
   Pen(,Solid)
   Line(-39,-36,-44,-41)
   Line(-39,-36,-44,-31)
   Pen(,ByNode,,mi)
   Line(-54,0,-39,0)
   Pen(,Solid)
   Line(-39,0,-44,-5)
   Line(-39,0,-44,5)
   Pen(,ByNode)
   Line(-54,36,-39,36)
   Pen(,Solid)
   Line(-39,36,-44,31)
   Line(-39,36,-44,41)
   Pen(,ByNode,,g1)
   Line(54,-90,39,-90)
   Pen(,,,g2)
   Line(54,-54,39,-54)
   Pen(,,,g3)
   Line(54,-18,39,-18)
   Pen(,,,g4)
   Line(54,18,39,18)
   Pen(,,,g5)
   Line(54,54,39,54)
   Pen(,,,g6)
   Line(54,90,39,90)
   Pen(Gray,Solid,0.2)
   Brush(Solid,Silver)
   Ellipse(-3,-4,4,3)
   Line(0,-1,-5,-11)
   Pen(Silver)
   Ellipse(-2,9,3,14)
   Ellipse(-2,-16,3,-11)
   Pen(Gray)
   Line(-5,-7,-5,-11)
   Line(-5,-11,-2,-8)
   Pen(Silver)
   Ellipse(-15,-3,-10,2)
   Ellipse(11,-3,16,2)
   Ellipse(-11,-13,-6,-8)
   Ellipse(7,-13,12,-8)
   Ellipse(7,5,12,10)
   Ellipse(-11,5,-6,10)
   Text(-46,-40,"Vac")
   Text(-46,-4,"MI")
   Text(-46,32,"Vdc")
   Text(46,-94,"1")
   Text(46,-58,"2")
   Text(46,-22,"3")
   Text(46,14,"4")
   Text(46,50,"5")
   Text(46,86,"6")
   Text(1,33,"Controls")
   }


  Page(A/A4,Portrait,144,[597,467],5)
   {
   0.import([234,648],0,0,20)
    {
    Name = "Vinv"
    }
   0.import([918,648],0,0,50)
    {
    Name = "mi"
    }
   0.import([126,1134],0,0,100)
    {
    Name = "dcVltgI"
    }
   0.export([1134,1314],4,0,580)
    {
    Name = "g1"
    }
   0.export([1134,1350],4,0,560)
    {
    Name = "g2"
    }
   0.export([1134,1386],4,0,540)
    {
    Name = "g3"
    }
   0.export([1134,1422],4,0,520)
    {
    Name = "g4"
    }
   0.export([1134,1458],4,0,500)
    {
    Name = "g5"
    }
   0.export([1134,1494],4,0,480)
    {
    Name = "g6"
    }
   0.datalabel([900,1350],1,0,-1)
    {
    Name = "RefIon"
    }
   0.datalabel([900,1422],1,0,-1)
    {
    Name = "RefIoff"
    }
   0.datalabel([1026,702],3,0,-1)
    {
    Name = "RefIon"
    }
   0.datalabel([1026,882],3,0,-1)
    {
    Name = "RefIoff"
    }
   0.time-sig([756,1260],0,0,140)
    {
    }
   0.compare([828,1260],0,0,150)
    {
    X = "0.2"
    OL = "0"
    OH = "1"
    INTR = "0"
    }
   0.tvekta([180,396],0,0,210)
    {
    Gp = "GpPLL"
    Gi = "GiPLL"
    Vbas = "100.0 [V]"
    Fbas = "60.0 [Hz]"
    Mode = "0"
    PMode = "1"
    THOFF = "0.0"
    TREL = "0.05"
    dlead = "1"
    FName = "Fre"
    Err = ""
    }
   -Wire-([108,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([108,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([108,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .moduloMR([414,396],0,0,230)
    {
    Mdl = "360.0"
    }
   0.mult([324,396],0,0,220)
    {
    }
   -Wire-([252,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([306,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([306,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([306,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .SinArray([864,702],0,0,400)
    {
    }
   0.datatap([756,756],3,0,320)
    {
    Index = "4"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([738,882],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   0.datatap([756,774],3,0,330)
    {
    Index = "5"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,792],3,0,340)
    {
    Index = "6"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,810],3,0,350)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,828],3,0,360)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,846],3,0,370)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([702,702],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([702,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([648,702],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   0.datamerge([810,828],4,0,380)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([756,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .SinArray([864,882],0,0,390)
    {
    }
   0.datalabel([648,558],0,0,-1)
    {
    Name = "TrgIoff"
    }
   0.datalabel([738,450],0,0,-1)
    {
    Name = "TrgIon"
    }
   0.datalabel([1008,1314],2,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([1008,1422],2,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([1008,1494],2,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([1008,1386],2,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([1008,1350],2,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([1008,1458],2,0,-1)
    {
    Name = "g5"
    }
   0.fp_int([936,1458],0,0,450)
    {
    Type = "1"
    PNum = "1"
    Blck = "1"
    PFormat = "0"
    detect = "0"
    max = "360.0 [deg]"
    min = "0.0 [deg]"
    BType = "0"
    PTime = "0.005 [s]"
    }
   .MultArray([972,702],0,0,420)
    {
    }
   .MultArray([972,882],6,0,410)
    {
    }
   0.datalabel([972,648],2,0,-1)
    {
    Name = "mi"
    }
   0.nl_tfun([504,360],0,0,280)
    {
    N = "4"
    x1 = "0.0"
    y1 = "0.0"
    x2 = "90.0"
    y2 = "1.0"
    x3 = "270.0"
    y3 = "-1.0"
    x4 = "360.0"
    y4 = "0.0"
    x5 = "0.0"
    y5 = "0.0"
    x6 = "1.0"
    y6 = "1.0"
    x7 = "2.0"
    y7 = "2.0"
    x8 = "3.0"
    y8 = "3.0"
    x9 = "4.0"
    y9 = "4.0"
    x10 = "5.0"
    y10 = "5.0"
    }
   -Wire-([468,360],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datamerge([738,396],4,0,440)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([684,324],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([684,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([540,360],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([666,360],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([666,324],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([684,342],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([684,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,414],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,396],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.nl_tfun([504,432],0,0,240)
    {
    N = "4"
    x1 = "0.0"
    y1 = "0.0"
    x2 = "90.0"
    y2 = "-1.0"
    x3 = "270.0"
    y3 = "1.0"
    x4 = "360.0"
    y4 = "0.0"
    x5 = "0.0"
    y5 = "0.0"
    x6 = "1.0"
    y6 = "1.0"
    x7 = "2.0"
    y7 = "2.0"
    x8 = "3.0"
    y8 = "3.0"
    x9 = "4.0"
    y9 = "4.0"
    x10 = "5.0"
    y10 = "5.0"
    }
   0.datamerge([648,504],4,0,430)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([594,432],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([594,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([576,504],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([576,468],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([576,432],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([594,450],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([594,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([594,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([594,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([576,468],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([540,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([558,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,378],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([558,360],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   0.datalabel([900,1386],1,0,-1)
    {
    Name = "TrgIon"
    }
   0.datalabel([900,1458],1,0,-1)
    {
    Name = "TrgIoff"
    }
   -Sticky-([702,1170],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 702,1170,810,1206
    Alignment = 0
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "\
blocking of inverter
for first 0.2 s"
    }
   -Wire-([864,1260],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   .PhaseShifter([594,702],0,0,310)
    {
    }
   -Wire-([450,702],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.sumjct([540,756],0,0,300)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Sticky-([288,846],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 288,846,522,918
    Alignment = 0
    Style = 1
    Arrow = 32
    Color = 0,15792890
    Text = "The phase shift for the receiving end pulses requires a 30 degree phase shift to compensate for the star-delta transformer."
    }
   0.pgb([594,630],0,22768848,610)
    {
    Name = "PLL error"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([432,630],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([432,630],2,0,-1)
    {
    Name = "Pllerr"
    }
   0.realpole([522,630],0,0,460)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.002 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Sticky-([72,198],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,198,270,288
    Alignment = 0
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "Receiving end ac voltage phase angle as determined by the phase locked loop - telecommunicated to the sending end with a 10ms  transmission delay."
    }
   0.datalabel([414,324],2,0,-1)
    {
    Name = "REPh"
    }
   -Wire-([270,396],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([270,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.tdelay([342,324],0,0,470)
    {
    T = "0.01 [s]"
    N = "100"
    Intp = "0"
    COM = "Delay"
    }
   -Wire-([378,324],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([576,756],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([972,1314],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([972,1350],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([972,1386],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([972,1422],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([972,1458],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([972,1494],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([576,414],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([576,414],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.pgb([1044,1314],0,24647872,590)
    {
    Name = "g1"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1044,1350],0,24952248,570)
    {
    Name = "g2"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1044,1386],0,24173832,550)
    {
    Name = "g3"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1044,1422],0,23718488,530)
    {
    Name = "g4"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1044,1458],0,22837008,510)
    {
    Name = "g5"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1044,1494],0,18811536,490)
    {
    Name = "g6"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([936,1260],2,0,-1)
    {
    Name = "BlkI"
    }
   0.datalabel([774,810],2,0,-1)
    {
    Name = "Vsina"
    }
   0.const([576,792],2,0,90)
    {
    Name = ""
    Value = "30"
    }
   0.var_pot([288,468],0,46080104,10)
    {
    Name = "<PWM Setting>"
    Group = ""
    Display = "0"
    NDP = "5"
    Value = "5"
    F1 = "9.0"
    F2 = "15.0"
    F3 = "21.0"
    F4 = "27.0"
    F5 = "33.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   -Sticky-([432,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 432,504,522,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Triangular signal
generators"
    }
   0.arrow_s([504,504],2,0,-1)
    {
    }
   -Sticky-([36,504],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 36,504,252,630
    Alignment = 0
    Style = 1
    Arrow = 32
    Color = 0,15792890
    Text = "This number defines the triangular wave carrier frequency, it is a multiplication of fundamental freqency,its value has to be dividable by three and an odd number.  It is adjusted by the dial selector located at the sending end controls."
    }
   -Sticky-([468,198],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 468,198,630,306
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "User-defined component:       This component represents a function MODULO, user has to specify the modulo factor which in this case limits the ramp  function between 0 to 360 degrees."
    }
   -Sticky-([774,270],0)
    {
    Name = ""
    Font = 1
    Bounds = 774,270,1062,324
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "PWM triangular carrier signal array at  a frequency 33 times or less of  fundamental frequency for turning GTOs on."
    }
   -Sticky-([684,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 684,504,990,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
PWM triangular carrier signal array at  a frequency
33 times or less of  fundamental frequency for 
turning GTOs off."
    }
   0.arrow_s([684,540],1,0,-1)
    {
    }
   -Sticky-([864,756],0)
    {
    Name = ""
    Font = 1
    Bounds = 864,756,1206,810
    Alignment = 0
    Style = 1
    Arrow = 3
    Color = 0,15792890
    Text = "PWM sinusoidal reference signal arrays at fundamental frequency  whose magnitude is controlled by signal \"mi\" and whose phase is controlled by signal \"Shfti\""
    }
   -Sticky-([864,1008],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 864,1008,1206,1206
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Firing pulse generator for receiving end converter:
 - firing pulses are generated using comparison  
   of reference signals to triangular signals 
 - two sets of signals (reference and triangular ones) 
   are needed, one set for turning on and the second 
   one (a negation of the first set of signals) for turning off 
 - two signals are being sent to each switch, 
   the first one tells to turn on or off, the 
   second one  determines an exact moment of switching 
   and is used by interpolation procedure which 
   allows for exact switching between time steps.

Firing pulses can be plotted."
    }
   -Wire-([324,468],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Sticky-([684,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 684,612,846,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Phase locked loop error signal"
    }
   0.arrow_s([684,630],1,0,-1)
    {
    }
   -Wire-([558,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,756],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([450,756],0,0,-1)
    {
    Name = "Shfti"
    }
   0.datalabel([972,936],0,0,-1)
    {
    Name = "mi"
    }
   -Wire-([936,1260],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.tvekta([378,702],0,0,190)
    {
    Gp = "GpPLL"
    Gi = "GiPLL"
    Vbas = "100.0 [V]"
    Fbas = "60.0 [Hz]"
    Mode = "1"
    PMode = "1"
    THOFF = "0.0"
    TREL = "0.05"
    dlead = "1"
    FName = ""
    Err = "Pllerr"
    }
   0.datatap2([108,360],0,0,160)
    {
    Type = "2"
    Index = "1"
    NameR = "VInv"
    NameI = ""
    NameL = ""
    }
   0.datatap2([108,432],0,0,180)
    {
    Type = "2"
    Index = "3"
    NameR = "VInv"
    NameI = ""
    NameL = ""
    }
   0.datatap2([108,396],0,0,170)
    {
    Type = "2"
    Index = "2"
    NameR = "VInv"
    NameI = ""
    NameL = ""
    }
   0.radiolink([558,324],0,0,620)
    {
    Source = ""
    Name = "REph"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   0.var([126,828],1,23381248,70)
    {
    Name = "GpPLL"
    Group = ""
    Display = "0"
    Max = "100.0"
    Min = "0.0"
    Value = "75.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([180,864],0,0,-1)
    {
    Name = "GiPLL"
    }
   0.var([180,828],1,25364904,80)
    {
    Name = "GiPLL"
    Group = ""
    Display = "0"
    Max = "1000.0"
    Min = "0.0"
    Value = "500.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([126,864],0,0,-1)
    {
    Name = "GpPLL"
    }
   -ControlPanel-([72,702],0)
    {
    Name = "PLL gain settings"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 72,702
    Extents = 0,0,144,126
    Slider(23381248)
    Slider(25364904)
    }
   0.sumjct([252,1170],6,0,120)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([180,1170],0,0,110)
    {
    Name = "Dc Volts Set Point"
    Value = "118"
    }
   -Wire-([504,1206],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.var([198,1224],0,23443760,130)
    {
    Name = "DcGain"
    Group = ""
    Display = "0"
    Max = "10.0"
    Min = "-10.0"
    Value = "2.5"
    Units = ""
    Collect = "1"
    }
   -ControlPanel-([90,1224],0)
    {
    Name = "DC Volt Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 90,1224
    Extents = 0,0,72,126
    Slider(23443760)
    }
   0.mult([288,1260],6,0,200)
    {
    }
   0.mult([324,1170],0,0,250)
    {
    }
   0.pgb([594,1170],0,24529592,600)
    {
    Name = "AngleVdc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200"
    Max = "200"
    }
   0.realpole([432,1170],0,0,260)
    {
    Limit = "1"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "0.2"
    T = "0.01 [s]"
    Max = "6.0"
    Min = "-6.0"
    }
   -Wire-([252,1260],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.integral([432,1242],0,0,270)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "0.4 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "4.0"
    YLo = "-4.0"
    }
   -Wire-([396,1170],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([378,1170],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([378,1242],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([594,1170],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([504,1242],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([324,1260],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.sumjct([504,1170],0,0,290)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([288,1224],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([252,1134],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.datalabel([198,1134],0,0,-1)
    {
    Name = "dcVltgI"
    }
   0.datalabel([216,1260],2,0,-1)
    {
    Name = "BlkI"
    }
   -Sticky-([54,972],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,972,198,1008
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "DC VOLTAGE CONTROLLER"
    }
   -Sticky-([54,1026],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,1026,270,1080
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Measured dc volts \"dcVltgl\" and dc voltage set point at receiving end (in kV)."
    }
   -Sticky-([270,1332],0)
    {
    Name = ""
    Font = 1
    Bounds = 270,1332,540,1494
    Alignment = 0
    Style = 1
    Arrow = 16
    Color = 0,15792890
    Text = "\
The gain of the dc controls is readily adjustable
by the \"DcGain\" slider.  The control is active
when converters are deblocked.  The control
acts to adjust the phase of the ac side of the 
receiving end converter.  When dc volts are too
high, the phase angle is adjusted to push 
power into the receiving end ac system.  If
more power is thus extracted from the dc
system than is ordered by the sending end
power controller, the cable and capacitors will
discharge, and dc volts will lower."
    }
   0.datalabel([576,1170],0,0,-1)
    {
    Name = "Shfti"
    }
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,18,1170,90
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
VSC TRANSMISSION WITH AC TRANSMISSION CHARACTERISTICS
Receiving End Controls Subpage"
    }
   0.datatap([306,666],0,0,30)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([306,702],0,0,40)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([306,738],0,0,60)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([288,630],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([288,630],2,0,-1)
    {
    Name = "VInv"
    }
   }
  }
 Module("SECtrl")
  {
  Desc = ""
  FileDate = 1144362028
  Nodes = 
   {
   Input("VRec",-54,-36)
    {
    Type = Real
    Dim  = [3]
    }
   Input("mr",-54,0)
    {
    Type = Real
    }
   Input("P",-54,36)
    {
    Type = Real
    }
   Output("g1",54,-90)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g2",54,-54)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g3",54,-18)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g4",54,18)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g5",54,54)
    {
    Type = Real
    Dim  = [2]
    }
   Output("g6",54,90)
    {
    Type = Real
    Dim  = [2]
    }
   }

  Graphics = 
   {
   Rectangle(-39,-111,39,111)
   Pen(ByNode,ByNode,ByNode)
   Line(-54,-36,-39,-36)
   Pen(,Solid)
   Line(-39,-36,-44,-41)
   Line(-39,-36,-44,-31)
   Pen(,ByNode)
   Line(-54,0,-39,0)
   Pen(,Solid)
   Line(-39,0,-44,-5)
   Line(-39,0,-44,5)
   Pen(,ByNode,,P)
   Line(-54,36,-39,36)
   Pen(,Solid)
   Line(-39,36,-44,31)
   Line(-39,36,-44,41)
   Pen(,ByNode,,g1)
   Line(54,-90,39,-90)
   Pen(,,,g2)
   Line(54,-54,39,-54)
   Pen(,,,g3)
   Line(54,-18,39,-18)
   Pen(,,,g4)
   Line(54,18,39,18)
   Pen(,,,g5)
   Line(54,54,39,54)
   Pen(,,,g6)
   Line(54,90,39,90)
   Pen(Gray,Solid,0.2)
   Brush(Solid,Silver)
   Ellipse(-3,-4,4,3)
   Line(0,-1,-5,-11)
   Pen(Silver)
   Ellipse(-2,9,3,14)
   Ellipse(-2,-16,3,-11)
   Pen(Gray)
   Line(-5,-7,-5,-11)
   Line(-5,-11,-2,-8)
   Pen(Silver)
   Ellipse(-15,-3,-10,2)
   Ellipse(11,-3,16,2)
   Ellipse(-11,-13,-6,-8)
   Ellipse(7,-13,12,-8)
   Ellipse(7,5,12,10)
   Ellipse(-11,5,-6,10)
   Text(-46,-40,"V")
   Text(-46,-4,"MI")
   Text(-46,32,"P")
   Text(46,-94,"1")
   Text(46,-58,"2")
   Text(46,-22,"3")
   Text(46,14,"4")
   Text(46,50,"5")
   Text(46,86,"6")
   Text(1,33,"Controls")
   }


  Page(B/A3,Landscape,16,[597,467],5)
   {
   0.import([198,522],0,0,10)
    {
    Name = "VRec"
    }
   0.import([612,846],0,0,160)
    {
    Name = "mr"
    }
   0.import([1404,540],0,0,100)
    {
    Name = "P"
    }
   0.export([1782,1008],4,0,690)
    {
    Name = "g1"
    }
   0.export([1782,1044],4,0,680)
    {
    Name = "g2"
    }
   0.export([1782,1080],4,0,670)
    {
    Name = "g3"
    }
   0.export([1782,1116],4,0,660)
    {
    Name = "g4"
    }
   0.export([1782,1152],4,0,650)
    {
    Name = "g5"
    }
   0.export([1782,1188],4,0,640)
    {
    Name = "g6"
    }
   -Sticky-([18,306],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,306,180,342
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SE VALVE FIRING CONTROLLER"
    }
   0.var([144,666],1,24443416,90)
    {
    Name = "GpPLL"
    Group = ""
    Display = "0"
    Max = "100.0"
    Min = "0.0"
    Value = "75.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([198,702],0,0,-1)
    {
    Name = "GiPLL"
    }
   0.var([198,666],1,24827752,110)
    {
    Name = "GiPLL"
    Group = ""
    Display = "0"
    Max = "1000.0"
    Min = "0.0"
    Value = "500.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([144,702],0,0,-1)
    {
    Name = "GpPLL"
    }
   0.tvekta([342,594],0,0,230)
    {
    Gp = "GpPLL"
    Gi = "GiPLL"
    Vbas = "13.8 [V]"
    Fbas = "60.0 [Hz]"
    Mode = "0"
    PMode = "1"
    THOFF = "0.0"
    TREL = "0.05"
    dlead = "1"
    FName = "Fsep"
    Err = ""
    }
   -Wire-([270,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([270,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([270,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .moduloMR([576,594],0,0,250)
    {
    Mdl = "360.0"
    }
   0.mult([486,594],6,0,240)
    {
    }
   0.nl_tfun([666,558],0,0,330)
    {
    N = "4"
    x1 = "0.0"
    y1 = "0.0"
    x2 = "90.0"
    y2 = "1.0"
    x3 = "270.0"
    y3 = "-1.0"
    x4 = "360.0"
    y4 = "0.0"
    x5 = "0.0"
    y5 = "0.0"
    x6 = "1.0"
    y6 = "1.0"
    x7 = "2.0"
    y7 = "2.0"
    x8 = "3.0"
    y8 = "3.0"
    x9 = "4.0"
    y9 = "4.0"
    x10 = "5.0"
    y10 = "5.0"
    }
   -Wire-([630,558],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datamerge([810,558],4,0,340)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([756,486],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([756,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([702,558],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([738,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,486],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([756,504],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([756,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([810,612],0,0,-1)
    {
    Name = "TrgRon"
    }
   -Wire-([738,522],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.nl_tfun([666,630],0,0,260)
    {
    N = "4"
    x1 = "0.0"
    y1 = "0.0"
    x2 = "90.0"
    y2 = "-1.0"
    x3 = "270.0"
    y3 = "1.0"
    x4 = "360.0"
    y4 = "0.0"
    x5 = "0.0"
    y5 = "0.0"
    x6 = "1.0"
    y6 = "1.0"
    x7 = "2.0"
    y7 = "2.0"
    x8 = "3.0"
    y8 = "3.0"
    x9 = "4.0"
    y9 = "4.0"
    x10 = "5.0"
    y10 = "5.0"
    }
   0.datamerge([810,702],4,0,350)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([756,630],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([756,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,702],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,630],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([756,648],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([756,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,666],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([702,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.fp_int([1638,1152],0,0,630)
    {
    Type = "1"
    PNum = "1"
    Blck = "1"
    PFormat = "0"
    detect = "0"
    max = "360.0 [deg]"
    min = "0.0 [deg]"
    BType = "0"
    PTime = "0.005 [s]"
    }
   -Wire-([630,576],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.datalabel([1620,972],2,0,-1)
    {
    Name = "deblk"
    }
   0.datalabel([738,900],3,0,-1)
    {
    Name = "RefRon"
    }
   0.datalabel([738,1080],3,0,-1)
    {
    Name = "RefRoff"
    }
   0.datalabel([1602,1080],2,0,-1)
    {
    Name = "TrgRon"
    }
   0.datalabel([1602,1152],2,0,-1)
    {
    Name = "TrgRoff"
    }
   0.datalabel([1602,1044],2,0,-1)
    {
    Name = "RefRon"
    }
   0.datalabel([1602,1116],2,0,-1)
    {
    Name = "RefRoff"
    }
   0.tvekta([180,900],0,0,280)
    {
    Gp = "GpPLL"
    Gi = "GiPLL"
    Vbas = "13.8 [V]"
    Fbas = "60.0 [Hz]"
    Mode = "1"
    PMode = "1"
    THOFF = "0.0"
    TREL = "0.05"
    dlead = "1"
    FName = ""
    Err = ""
    }
   -Wire-([108,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([108,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([108,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .PhaseShifter([324,900],0,0,510)
    {
    }
   -Wire-([252,900],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([378,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([468,954],3,0,560)
    {
    Index = "4"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([450,1080],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   0.datatap([468,972],3,0,550)
    {
    Index = "5"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,990],3,0,540)
    {
    Index = "6"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,1008],3,0,530)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,1026],3,0,520)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([468,1044],3,0,570)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([414,900],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([414,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,900],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datamerge([522,1026],4,0,580)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([468,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([324,1008],3,0,500)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   0.const([252,1008],0,0,190)
    {
    Name = ""
    Value = "30.0"
    }
   -Wire-([720,558],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Sticky-([468,396],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 468,396,648,504
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
User-defined component: 
      This component represents 
      a function MODULO, user
      has to specify the modulo
      factor which in this case
      limits the ramp  function 
      between 0 to 360 degrees."
    }
   0.arrow_s([576,504],0,0,-1)
    {
    }
   -Sticky-([234,378],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 234,378,414,504
    Alignment = 0
    Style = 1
    Arrow = 132
    Color = 0,15792890
    Text = "This number defines the triangular wave carrier frequency, it is a multiplication of fundamental freqency,its value has to be dividable by three and an odd number."
    }
   -Sticky-([72,738],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,738,288,810
    Alignment = 0
    Style = 1
    Arrow = 35
    Color = 0,15792890
    Text = "Phase Lock Loop proportional - integral gain constants. "
    }
   -ControlPanel-([72,540],0)
    {
    Name = "PLL gain settings"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 72,540
    Extents = 0,0,144,126
    Slider(24443416)
    Slider(24827752)
    }
   -Sticky-([1674,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1674,900,1782,936
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "blocking of rectifier for first 0.2 s"
    }
   -Wire-([1584,972],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([324,1062],0,0,-1)
    {
    Name = "Shft"
    }
   .MultArray([684,900],0,0,620)
    {
    }
   .MultArray([684,1080],0,0,610)
    {
    }
   0.datalabel([684,1026],2,0,-1)
    {
    Name = "mr"
    }
   0.datalabel([684,846],2,0,-1)
    {
    Name = "mr"
    }
   -Wire-([414,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.tdelay([468,684],0,0,270)
    {
    T = "0.01 [s]"
    N = "100"
    Intp = "0"
    COM = "Delay"
    }
   -Wire-([432,684],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.datalabel([540,684],2,0,-1)
    {
    Name = "SEPh"
    }
   -Wire-([504,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([360,756],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 360,756,594,828
    Alignment = 0
    Style = 1
    Arrow = 33
    Color = 0,15792890
    Text = "\
Delay function added at the sending end
measurement of ac voltage phase angle 
to match the telecom delay from the 
receiving end (10 ms)"
    }
   -Wire-([324,972],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([324,1062],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Sticky-([864,540],0)
    {
    Name = ""
    Font = 1
    Bounds = 864,540,1116,612
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "PWM triangular carrier signal array at  a frequency 33 times fundamental frequency for turning GTOs on."
    }
   -Sticky-([864,684],0)
    {
    Name = ""
    Font = 1
    Bounds = 864,684,1116,756
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "PWM triangular carrier signal array at  a frequency 33 times fundamental frequency for turning GTOs off."
    }
   -Sticky-([540,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 540,954,864,1008
    Alignment = 0
    Style = 1
    Arrow = 3
    Color = 0,15792890
    Text = "PWM sinusoidal reference signal arrays at fundamental frequency  whose magnitude is controlled by signal \"mr\" and whose phase is controlled by signal \"Shft\""
    }
   -Sticky-([666,432],0)
    {
    Name = ""
    Font = 1
    Bounds = 666,432,756,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Triangular signal
generators"
    }
   0.arrow_s([684,468],0,0,-1)
    {
    }
   0.var_pot([432,558],0,25033024,50)
    {
    Name = "<PWM Setting>"
    Group = ""
    Display = "0"
    NDP = "5"
    Value = "5"
    F1 = "9.0"
    F2 = "15.0"
    F3 = "21.0"
    F4 = "27.0"
    F5 = "33.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   -Wire-([468,558],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -ControlPanel-([90,378],0)
    {
    Name = "SE PWM Freq"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 90,378
    Extents = 0,0,108,126
    Dial(25033024)
    }
   -Sticky-([36,990],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,990,216,1116
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\"Shft\" is the phase angle order in degrees derived from the open loop power controller.  It is the angle by which the voltage across the sending end transformer is phase shifted in order to control power flow."
    }
   0.datatap2([108,864],0,0,140)
    {
    Type = "2"
    Index = "1"
    NameR = "VRec"
    NameI = ""
    NameL = ""
    }
   0.datatap2([108,936],0,0,180)
    {
    Type = "2"
    Index = "3"
    NameR = "VRec"
    NameI = ""
    NameL = ""
    }
   0.datatap2([108,900],0,0,170)
    {
    Type = "2"
    Index = "2"
    NameR = "VRec"
    NameI = ""
    NameL = ""
    }
   -Sticky-([1476,1242],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1476,1242,1818,1422
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Firing pulse generator for sending end converter:
 - firing pulses are generated using comparison  
   of reference signals to triangular signals 
 - two sets of signals (reference and triangular ones) 
   are needed, one set for turning on and the second 
   one (a negation of the first set of signals) for turning off 
 - two signals are being sent to each switch, 
   the first one tells to turn on or off, the 
   second one  determines an exact moment of switching 
   and is used by interpolation procedure which 
   allows for exact switching between time steps"
    }
   0.trig([594,1080],0,0,590)
    {
    Type = "1"
    Mode = "1"
    COM = "Trig-Func"
    Dim = "6"
    }
   0.trig([594,900],0,0,600)
    {
    Type = "1"
    Mode = "1"
    COM = "Trig-Func"
    Dim = "6"
    }
   -Wire-([522,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([1566,702],0)
    {
    Name = ""
    Font = 1
    Bounds = 1566,702,1836,792
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "The synthesized phase angle across the transmission line is filtered, then phase advanced to cause ac system damping.  Gain is automatically reduced if high frequency control oscillations are detected."
    }
   -Sticky-([1224,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 1224,612,1422,792
    Alignment = 0
    Style = 1
    Arrow = 32
    Color = 0,15792890
    Text = "\
Pdc - Dc power into sending 
end cables multiplied by 
approximate short circuit  
impedance summed from 
ac systems at sending and 
receiving ends.  When added
to the measured phase 
difference, an approximated 
extended  phase angle from
which to generate ac 
line characteristics is derived."
    }
   -Wire-([2016,540],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.pgb([1998,540],3,44788808,740)
    {
    Name = "Ao"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "rad"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([1296,378],2,0,-1)
    {
    Name = "SEPh"
    }
   0.datalabel([1836,378],6,0,-1)
    {
    Name = "REPh"
    }
   0.pgb([1566,486],0,24605080,750)
    {
    Name = "PhDiff"
    Group = ""
    Display = "1"
    Scale = "57.2958"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Wire-([1566,504],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([1602,540],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   0.sumjct([1566,540],0,0,390)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.gain([1494,540],0,0,120)
    {
    G = "0.00225"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([1458,540],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.sumjct([2052,540],0,0,470)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([2052,612],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1602,612],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.mult([1926,612],0,0,440)
    {
    }
   0.var([1926,684],3,24227288,150)
    {
    Name = "Damping"
    Group = ""
    Display = "0"
    Max = "1"
    Min = "0"
    Value = "0.15"
    Units = ""
    Collect = "1"
    }
   0.pgb([2052,594],0,44756656,720)
    {
    Name = "DeltaA"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "rad"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1854,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([1674,648],0,24776368,710)
    {
    Name = "DA"
    Group = ""
    Display = "1"
    Scale = "57.2958"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "35"
    }
   .Damping([1800,612],0,0,430)
    {
    }
   0.cmplx([1638,612],0,0,420)
    {
    G = "1.0"
    DR = "0.707"
    F = "2.5 [Hz]"
    HP = "0"
    MP = "0"
    LP = "1"
    }
   -Wire-([1674,648],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1980,612],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1890,612],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1908,720],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   .GainAdjust([1962,720],0,0,450)
    {
    }
   -Wire-([2016,648],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.pgb([2016,720],0,24744464,700)
    {
    Name = "GRed"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "rad"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.mult([2016,612],0,0,460)
    {
    }
   0.gain([1818,540],0,0,400)
    {
    G = "0.135"
    COM = "Gain"
    Dim = "1"
    }
   0.hardlimit([1926,540],0,0,410)
    {
    UL = "1.5"
    LL = "-1.5"
    COM = "Hard_Limit"
    }
   -Wire-([1854,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([1746,252],0)
    {
    Name = ""
    Font = 1
    Bounds = 1746,252,1872,324
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "REPh is receiving end phase angle  via telecommunication from receiving end PLL"
    }
   -Sticky-([1242,234],0)
    {
    Name = ""
    Font = 1
    Bounds = 1242,234,1422,306
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SEPh is sending end phase angle through delay to emulate transmission delay from receiving end."
    }
   0.arrow_s([1638,702],2,0,-1)
    {
    }
   0.arrow_s([1296,306],0,0,-1)
    {
    }
   -Sticky-([1638,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 1638,468,1818,504
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "Synthesized phase angle in radians"
    }
   -Wire-([1890,612],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.arrow_s([1800,702],2,0,-1)
    {
    }
   -Wire-([1674,612],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1332,378],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([1332,414],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([1404,342],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.sumjct([1368,414],0,0,300)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.sumjct([1494,378],0,0,360)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([1404,450],2,0,40)
    {
    Name = ""
    Value = "120.0"
    }
   0.trig([1440,342],0,0,290)
    {
    Type = "1"
    Mode = "1"
    COM = "Trig-Func"
    Dim = "1"
    }
   0.trig([1440,414],0,0,310)
    {
    Type = "1"
    Mode = "1"
    COM = "Trig-Func"
    Dim = "1"
    }
   0.phasediff([1566,378],7,0,380)
    {
    DorR = "0"
    Rms1 = ""
    Rms2 = ""
    View = "0"
    }
   -Wire-([1530,342],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1530,414],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1800,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1800,414],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([1728,342],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.sumjct([1764,414],4,0,220)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.sumjct([1638,378],4,0,370)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.const([1728,450],6,0,70)
    {
    Name = ""
    Value = "120.0"
    }
   0.trig([1692,342],4,0,210)
    {
    Type = "1"
    Mode = "1"
    COM = "Trig-Func"
    Dim = "1"
    }
   0.trig([1692,414],4,0,320)
    {
    Type = "1"
    Mode = "1"
    COM = "Trig-Func"
    Dim = "1"
    }
   -Wire-([1602,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1602,414],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.arrow_s([1836,324],0,0,-1)
    {
    }
   0.var([1566,612],3,46144680,130)
    {
    Name = "PhaseShift"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "-1.0"
    Value = "0.0"
    Units = "rad"
    Collect = "1"
    }
   -ControlPanel-([1458,630],0)
    {
    Name = "Aux PhCntrl"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1458,630
    Extents = 0,0,72,126
    Slider(46144680)
    }
   -Sticky-([1494,234],0)
    {
    Name = ""
    Font = 1
    Bounds = 1494,234,1656,270
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Phase difference between sending and receiving ends."
    }
   -Sticky-([1638,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1638,162,1854,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
OPEN LOOP POWER FLOW CONTROLLER
"
    }
   0.arrow_s([1746,198],0,0,-1)
    {
    }
   0.pgb([2286,540],0,22873496,730)
    {
    Name = "AngleOrder"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200"
    Max = "200"
    }
   -Wire-([2286,540],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([2268,540],2,0,-1)
    {
    Name = "Shft"
    }
   -Wire-([2178,540],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.gain([2124,540],0,0,480)
    {
    G = "57.2958"
    COM = "Gain"
    Dim = "1"
    }
   0.hardlimit([2214,540],0,0,490)
    {
    UL = "50.0"
    LL = "-50.0"
    COM = "Hard_Limit"
    }
   -Sticky-([2088,234],0)
    {
    Name = ""
    Font = 1
    Bounds = 2088,234,2358,324
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
This control causes the VSC Transmission
to emulate the characteristics of an ac line
by controlling power from the synthesized
ac voltage phase angle difference measured
between each end. "
    }
   -Sticky-([2088,414],0)
    {
    Name = ""
    Font = 1
    Bounds = 2088,414,2322,486
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Output power control signal \"Shft\" is
used to phase shift the ac side volts
of the sending end voltage sourced
converter (in degrees)."
    }
   0.arrow_s([2268,486],0,0,-1)
    {
    }
   -ControlPanel-([2088,666],0)
    {
    Name = "Damping gain"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 2088,666
    Extents = 0,0,72,126
    Slider(24227288)
    }
   -Wire-([1836,378],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.radiolink([1908,378],0,0,20)
    {
    Source = "RECtrl"
    Name = "REph"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   -Wire-([1674,1008],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1674,1044],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1674,1080],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1674,1116],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1674,1152],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1674,1188],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([666,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 666,18,1782,90
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
VSC TRANSMISSION WITH AC TRANSMISSION CHARACTERISTICS
Sending End Controls Subpage"
    }
   0.timerdefn([1548,972],4,0,200)
    {
    Timsw = "0.2 [s]"
    }
   0.datatap([270,558],0,0,30)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([270,594],0,0,60)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([270,630],0,0,80)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([252,522],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([252,522],2,0,-1)
    {
    Name = "VRec"
    }
   0.datalabel([1674,1188],3,0,-1)
    {
    Name = "Rg6"
    }
   0.datalabel([1674,1152],3,0,-1)
    {
    Name = "Rg5"
    }
   0.datalabel([1674,1116],3,0,-1)
    {
    Name = "Rg4"
    }
   0.datalabel([1674,1080],3,0,-1)
    {
    Name = "Rg3"
    }
   0.datalabel([1674,1044],3,0,-1)
    {
    Name = "Rg2"
    }
   0.datalabel([1674,1008],3,0,-1)
    {
    Name = "Rg1"
    }
   0.datalabel([810,756],0,0,-1)
    {
    Name = "TrgRoff"
    }
   -Divider-([1188,1422],0)
    {
    Size(0,-1260)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([2376,864],1)
    {
    Size(-1188,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("RE")
  {
  Desc = ""
  FileDate = 1144362028
  Nodes = 
   {
   }

  Graphics = 
   {
   Pen(,,0.6)
   Ellipse(-11,-58,25,-22)
   Ellipse(-36,-58,0,-22)
   Line(-51,-40,-36,-40)
   Line(25,-40,87,-40)
   Ellipse(88,-57,124,-21)
   Pen(,,0.2)
   Arc(107,-45,115,-30,180,-180)
   Arc(99,-45,107,-30,360,-180)
   Pen(,,0.6)
   Line(58,-40,58,11)
   Line(65,12,51,12)
   Line(64,17,51,17)
   Line(68,67,47,68)
   Line(65,72,51,72)
   Line(62,76,54,76)
   Pen(White,,0.2)
   Brush(Solid,White)
   Rectangle(-72,-50,-66,-39)
   Pen(Black,,0.6)
   Line(-69,-33,-69,-24)
   Line(-60,-33,-78,-33)
   Line(-60,-51,-69,-33)
   Line(-78,-51,-60,-51)
   Line(-69,-33,-78,-51)
   Line(-69,-60,-69,-51)
   Brush(Hollow)
   Rectangle(-87,-63,-51,-19)
   Line(-69,-77,-69,-64)
   Line(-69,-18,-69,-5)
   Line(-131,-5,-69,-5)
   Line(-131,-77,-69,-77)
   Line(-112,-77,-112,-45)
   Line(-112,-38,-112,-6)
   Line(-105,-44,-119,-44)
   Line(-105,-38,-119,-38)
   Pen(,,0.2)
   Rectangle(-144,-90,144,90)
   Pen(,,0.6)
   Line(58,17,58,68)
   Text(-132,82,"RE")
   }


  Page(A/A4,Portrait,144,[597,467],5)
   {
   -Sticky-([306,1116],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 306,1116,486,1206
    Alignment = 0
    Style = 1
    Arrow = 33
    Color = 0,15792890
    Text = "\
Parameters of PI controller for receiving end ac voltage control
(their values  are not optimal, find better ones)."
    }
   -Wire-([864,342],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([504,234],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([396,234],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([504,486],0,0,-1)
    {
    Vertex="0,0;-378,0"
    }
   -Wire-([504,486],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([396,486],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([288,486],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([504,198],0,0,-1)
    {
    Vertex="0,0;-360,0"
    }
   0.datalabel([540,270],4,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([324,468],6,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([432,270],4,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([540,468],6,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([324,270],4,0,-1)
    {
    Name = "g5"
    }
   0.datalabel([432,468],6,0,-1)
    {
    Name = "g6"
    }
   -Wire-([396,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([396,234],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([288,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([288,234],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([504,468],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([504,432],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([396,468],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([396,432],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([288,468],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([288,432],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([504,270],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([504,234],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.peswitch([504,234],6,0,500)
    {
    L = "1"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Igto1"
    It = ""
    V = "Vgto1"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([468,270],0,0,50)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "0"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "Idi1"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([396,234],6,0,510)
    {
    L = "3"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Igto3"
    It = ""
    V = "Vgto3"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([360,270],0,0,40)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "0"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "Idi3"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([288,234],6,0,520)
    {
    L = "5"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Igto5"
    It = ""
    V = "Vgto5"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([252,270],0,0,30)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "0"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "Idi5"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([504,432],6,0,460)
    {
    L = "4"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Igto4"
    It = ""
    V = "Vgto4"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([468,468],0,0,150)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "0"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "Idi4"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([396,432],6,0,470)
    {
    L = "6"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Igto6"
    It = ""
    V = "Vgto6"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([360,468],0,0,140)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "0"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "Idi6"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([288,432],6,0,480)
    {
    L = "2"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Igto2"
    It = ""
    V = "Vgto2"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([252,468],0,0,130)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "0"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "Idi2"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.pgb([972,936],0,24778136,260)
    {
    Name = "Vpu_I"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "1.2"
    }
   -Wire-([936,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([936,936],4,0,-1)
    {
    Name = "VpuI"
    }
   0.capacitor([198,342],3,0,-1)
    {
    C = "500.0 [uF]"
    }
   -Wire-([198,486],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   0.var([162,954],0,23822016,210)
    {
    Name = "Vref"
    Group = ""
    Display = "0"
    Max = "1.5"
    Min = "0.0"
    Value = "1.0"
    Units = ""
    Collect = "1"
    }
   0.sumjct([306,954],6,0,240)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.pi_ctlr([414,954],0,0,410)
    {
    GP = "PgainI"
    TI = "TconstI"
    YHI = "1.0"
    YLO = "-1.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   0.var([360,1008],1,24123664,270)
    {
    Name = "PgainI"
    Group = ""
    Display = "0"
    Max = "45.0"
    Min = "0.0"
    Value = "1.25"
    Units = ""
    Collect = "1"
    }
   0.datalabel([414,1044],0,0,-1)
    {
    Name = "TconstI"
    }
   0.var([414,1008],1,23355992,280)
    {
    Name = "TconstI"
    Group = ""
    Display = "0"
    Max = "10.0"
    Min = "0.0"
    Value = "0.1"
    Units = ""
    Collect = "1"
    }
   0.datalabel([360,1044],0,0,-1)
    {
    Name = "PgainI"
    }
   0.pgb([558,954],0,24540376,450)
    {
    Name = "ModIndex(mi)"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "1"
    }
   -Wire-([450,954],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([270,954],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([378,954],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([306,882],2,0,-1)
    {
    Name = "VpuI"
    }
   -Wire-([306,918],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.pgb([252,954],3,44775184,220)
    {
    Name = "Vref"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([360,954],3,44775584,250)
    {
    Name = "Verr"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([504,954],0,0,-1)
    {
    Name = "mi"
    }
   0.datalabel([1008,810],3,0,-1)
    {
    Name = "IaInv"
    }
   0.pgb([1008,810],4,23914936,190)
    {
    Name = "IaInv"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([1008,846],3,0,-1)
    {
    Name = "IbInv"
    }
   0.pgb([1008,846],4,23904912,200)
    {
    Name = "IbInv"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([1008,882],3,0,-1)
    {
    Name = "IcInv"
    }
   0.pgb([1008,882],4,22810768,230)
    {
    Name = "IcInv"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Sticky-([432,828],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 432,828,594,900
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "the output of PI controller is the modulation index used in PWM for voltage magnitude control"
    }
   -ControlPanel-([504,1008],0)
    {
    Name = "PI param. - Inv"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 504,1008
    Extents = 0,0,144,126
    Slider(24123664)
    Slider(23355992)
    }
   -Wire-([198,234],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.var([1008,270],1,22759800,70)
    {
    Name = "REPh"
    Group = ""
    Display = "0"
    Max = "100.0"
    Min = "-100"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1080,270],1,23353048,90)
    {
    Name = "REV"
    Group = ""
    Display = "0"
    Max = "150"
    Min = "100"
    Value = "115.0"
    Units = "Hz"
    Collect = "1"
    }
   0.ground([1080,342],6,0,-1)
    {
    }
   -ControlPanel-([954,144],0)
    {
    Name = "RE Source Parameters"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 954,144
    Extents = 0,0,216,126
    Slider(23353048)
    Slider(42797552)
    Slider(22759800)
    }
   0.datalabel([198,1350],0,0,-1)
    {
    Name = "dcVltgI"
    }
   -Wire-([198,1350],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.realpole([288,1350],0,0,350)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.pgb([396,1350],0,25116208,360)
    {
    Name = "dcVoltage Inv"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "160"
    }
   -Wire-([324,1350],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([1152,1008],0,50786688,320)
    {
    Name = "PowerI"
    Group = ""
    Display = "1"
    Scale = "-1"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "1.2"
    }
   0.pgb([1152,1062],0,24509640,340)
    {
    Name = "QpowerI"
    Group = ""
    Display = "1"
    Scale = "-1"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.5"
    }
   0.datalabel([1080,1008],5,0,-1)
    {
    Name = "SrcPI"
    }
   0.datalabel([1080,1062],5,0,-1)
    {
    Name = "SrcQI"
    }
   -Sticky-([792,504],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 792,504,900,540
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "10 MVAR capacitor"
    }
   -Wire-([846,342],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.capacitor([846,414],1,0,-1)
    {
    C = "2 [uF]"
    }
   0.ground([846,450],1,0,-1)
    {
    }
   -Wire-([1008,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.tfault([1062,450],0,0,160)
    {
    TF = "2.1 [s]"
    DF = "0.05 [s]"
    REP = "0"
    }
   0.datalabel([198,1422],0,0,-1)
    {
    Name = "dcCur"
    }
   -Wire-([198,1422],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.realpole([288,1422],0,0,380)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([324,1422],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([396,1422],0,24658208,390)
    {
    Name = "dcCurrent Inv"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "300"
    }
   0.mult([378,1386],0,0,420)
    {
    }
   -Wire-([342,1386],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([414,1386],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([450,1386],4,0,-1)
    {
    Name = "PdcI"
    }
   0.pgb([468,1386],0,24264312,430)
    {
    Name = "Pinv"
    Group = ""
    Display = "1"
    Scale = "0.01"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "2"
    }
   0.cable_interface([108,198],4,0,-1)
    {
    Name = "Cable2"
    NCAB = "2"
    C1T = "1"
    C2T = "1"
    C3T = "1"
    C4T = "1"
    C5T = "1"
    C6T = "1"
    }
   -Wire-([126,486],0,0,-1)
    {
    Vertex="0,0;0,-252"
    }
   0.pgb([234,1476],0,46381720,400)
    {
    Name = "dclineInv"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3"
    Max = "4"
    }
   -Wire-([234,1476],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.ammeter([198,270],3,0,20)
    {
    Name = "Icap"
    }
   -Wire-([198,306],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([288,234],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([288,432],0,0,-1)
    {
    Vertex="0,0;0,-162"
    }
   -Wire-([396,432],0,0,-1)
    {
    Vertex="0,0;0,-162"
    }
   -Wire-([504,432],0,0,-1)
    {
    Vertex="0,0;0,-162"
    }
   0.voltmetergnd([576,306],0,0,60)
    {
    Name = "ViPhA"
    }
   -Wire-([126,198],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([198,1278],0)
    {
    Name = ""
    Font = 1
    Bounds = 198,1278,414,1314
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Receiving end (inverter) dc voltage, 
current and power measurement."
    }
   -Sticky-([702,180],0)
    {
    Name = ""
    Font = 1
    Bounds = 702,180,918,234
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "Control of the receiving end ac system Thevenin voltage source."
    }
   -Sticky-([1080,882],0)
    {
    Name = ""
    Font = 1
    Bounds = 1080,882,1206,954
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Measured ac power and reactive power at the receiving end system."
    }
   -Sticky-([1062,792],0)
    {
    Name = ""
    Font = 1
    Bounds = 1062,792,1206,864
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Line (phase) currents of transformer low voltage (valve) side."
    }
   -Sticky-([54,864],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,864,216,900
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "Measured ac volts \"Vpul\"at receiving end (in pu)."
    }
   -Sticky-([54,1008],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,1008,270,1044
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Receiving end ac volts set point (pu)"
    }
   -Sticky-([252,738],0)
    {
    Name = ""
    Font = 1
    Bounds = 252,738,486,774
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "RECEIVING END AC VOLTAGE CONTROLLER"
    }
   -Sticky-([972,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,522,1188,576
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Fault application timer, set at 2.1 seconds (on the assunption that the snapshot is at 2.0 second)"
    }
   -ControlPanel-([108,1062],0)
    {
    Name = "Ac Volts"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 108,1062
    Extents = 0,0,72,126
    Slider(23822016)
    }
   -Wire-([918,756],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([972,756],0,24033352,180)
    {
    Name = "RE Ac V PhA"
    Group = ""
    Display = "1"
    Scale = "0.01065"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "2"
    }
   0.realpole([1116,1008],0,0,310)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.realpole([1116,1062],0,0,330)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.source3([1044,342],4,0,120)
    {
    Name = "Source2"
    Type = "3"
    Ctrl = "2"
    MVA = "100.0 [MVA]"
    Vm = "115.0 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.05 [s]"
    ZSeq = "0"
    Imp = "1"
    Exph = "1"
    View = "1"
    Term = "0"
    R1s = "1.0 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "26.45 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "1.0 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "230.0 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = "SrcPI"
    Q = "SrcQI"
    V = ""
    Theta = "SrcAI"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.var([1044,270],1,42797552,80)
    {
    Name = "REFr"
    Group = ""
    Display = "0"
    Max = "61.0"
    Min = "59.0"
    Value = "60.0"
    Units = "Hz"
    Collect = "1"
    }
   0.xfmr-3p2w([720,342],4,0,100)
    {
    Name = "t1"
    Tmva = "100.0 [MVA]"
    f = "60.0 [Hz]"
    YD1 = "0"
    YD2 = "1"
    Lead = "1"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "115.0 [kV]"
    V2 = "62.5 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "0.5 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = "IaInv"
    ILB2 = "IbInv"
    ILC2 = "IcInv"
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([738,378],7,0,-1)
    {
    }
   0.breakout([684,342],4,0,-1)
    {
    Dis = "0"
    }
   -Wire-([648,342],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   -Wire-([648,378],0,0,-1)
    {
    Vertex="0,0;-360,0"
    }
   -Wire-([648,306],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   0.tpflt([936,342],0,0,490)
    {
    Ctype = "0"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    A = "0"
    B = "0"
    C = "1"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([1008,450],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([972,378],0,0,-1)
    {
    Name = "Fault"
    }
   0.datatap2([918,756],0,0,170)
    {
    Type = "2"
    Index = "1"
    NameR = "VInv"
    NameI = ""
    NameL = ""
    }
   0.radiolink([198,1422],4,0,370)
    {
    Source = "SE"
    Name = "DCCurrent"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   0.pgb([972,990],0,24481056,300)
    {
    Name = "REVphA"
    Group = ""
    Display = "1"
    Scale = "0.01065"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "2"
    }
   -Wire-([918,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap2([918,990],0,0,290)
    {
    Type = "2"
    Index = "1"
    NameR = "VInv"
    NameI = ""
    NameL = ""
    }
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,18,1170,90
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
VSC TRANSMISSION WITH AC TRANSMISSION CHARACTERISTICS
Receiving End Subpage"
    }
   .RECtrl([954,1260],0,0,440)
    {
    }
   0.datalabel([1080,1170],4,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([1080,1206],4,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([1080,1242],4,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([1080,1278],4,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([1080,1314],4,0,-1)
    {
    Name = "g5"
    }
   0.datalabel([1080,1350],4,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([828,1224],0,0,-1)
    {
    Name = "VInv"
    }
   0.datalabel([828,1260],0,0,-1)
    {
    Name = "mi"
    }
   0.datalabel([828,1296],4,0,-1)
    {
    Name = "dcVltgI"
    }
   0.multimeter([882,342],4,0,110)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "115.0 [kV]"
    TS = "0.01 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "VInv"
    P = ""
    Q = ""
    Vrms = "VpuI"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([1008,342],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([828,1224],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([828,1260],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([828,1296],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1170],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1206],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1242],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1278],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1314],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1350],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Divider-([18,702],0)
    {
    Size(1188,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.voltmeter([126,198],0,0,10)
    {
    Name = "dcVltgI"
    }
   }
  }
 Module("SE")
  {
  Desc = ""
  FileDate = 1144362028
  Nodes = 
   {
   }

  Graphics = 
   {
   Pen(,,0.6)
   Ellipse(-25,-58,11,-22)
   Ellipse(0,-58,36,-22)
   Line(36,-40,51,-40)
   Line(-87,-40,-25,-40)
   Ellipse(-124,-57,-88,-21)
   Pen(,,0.2)
   Arc(-115,-45,-107,-30,0,180)
   Arc(-107,-45,-99,-30,-180,180)
   Pen(,,0.6)
   Line(-58,22,-58,-39)
   Line(-51,23,-65,23)
   Line(-51,29,-65,29)
   Line(-58,38,-58,29)
   Line(-53,43,-58,39)
   Line(-59,55,-64,51)
   Line(-52,43,-64,51)
   Line(-59,67,-59,54)
   Line(-47,68,-69,67)
   Line(-51,72,-65,72)
   Line(-54,76,-62,76)
   Line(69,-24,69,-33)
   Line(78,-33,60,-33)
   Line(69,-33,60,-51)
   Line(60,-51,78,-51)
   Line(78,-51,69,-33)
   Line(69,-51,69,-60)
   Rectangle(51,-63,87,-19)
   Line(69,-64,69,-77)
   Line(69,-5,69,-18)
   Line(69,-5,131,-5)
   Line(69,-77,131,-77)
   Line(112,-45,112,-77)
   Line(112,-6,112,-38)
   Line(119,-44,105,-44)
   Line(119,-38,105,-38)
   Pen(,,0.2)
   Rectangle(-144,-90,144,90)
   Text(132,82,"SE")
   }


  Page(A/A4,Portrait,152,[597,467],5)
   {
   -Wire-([306,378],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pgb([1080,900],0,25122768,470)
    {
    Name = "PowerR"
    Group = ""
    Display = "1"
    Scale = "0.01"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "1.2"
    }
   0.pgb([1080,846],0,25124592,480)
    {
    Name = "QpowerR"
    Group = ""
    Display = "1"
    Scale = "0.01"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.5"
    }
   -Wire-([756,270],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([864,270],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([972,270],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([756,450],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([864,450],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([972,450],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([756,522],0,0,-1)
    {
    Vertex="0,0;378,0"
    }
   -Wire-([756,522],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([864,522],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([972,522],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([756,234],0,0,-1)
    {
    Vertex="0,0;342,0"
    }
   0.datalabel([720,306],0,0,-1)
    {
    Name = "Rg1"
    }
   0.datalabel([936,486],0,0,-1)
    {
    Name = "Rg2"
    }
   0.datalabel([828,306],2,0,-1)
    {
    Name = "Rg3"
    }
   0.datalabel([720,486],0,0,-1)
    {
    Name = "Rg4"
    }
   0.datalabel([936,306],0,0,-1)
    {
    Name = "Rg5"
    }
   0.datalabel([828,486],0,0,-1)
    {
    Name = "Rg6"
    }
   -Wire-([864,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([864,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([972,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([972,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([864,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([864,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([972,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([972,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.peswitch([756,270],2,0,600)
    {
    L = "1"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "IgtoR1"
    It = ""
    V = "VgtoR1"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([792,306],4,0,30)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "1"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "IdiR1"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.ammeter([1098,234],0,0,20)
    {
    Name = "dcCur"
    }
   0.peswitch([864,270],2,0,590)
    {
    L = "3"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "IgtoR3"
    It = ""
    V = "VgtoR3"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([900,306],4,0,50)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "1"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "IdiR3"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([972,270],2,0,580)
    {
    L = "5"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "IgtoR5"
    It = ""
    V = "VgtoR5"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([1008,306],4,0,60)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "1"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "IdiR5"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([756,450],2,0,540)
    {
    L = "4"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "IgtoR4"
    It = ""
    V = "VgtoR4"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([792,486],4,0,130)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "1"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "IdiR4"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([864,450],2,0,530)
    {
    L = "6"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "IgtoR6"
    It = ""
    V = "VgtoR6"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([900,486],4,0,140)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "1"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "IdiR6"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([972,450],2,0,520)
    {
    L = "2"
    Type = "2"
    SNUB = "0"
    INTR = "1"
    RON = "0.005 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "IgtoR2"
    It = ""
    V = "VgtoR2"
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([1008,486],4,0,160)
    {
    L = ""
    Type = "0"
    SNUB = "1"
    INTR = "1"
    RON = "0.005[ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.01 [uF]"
    PFB = "0"
    I = "IdiR2"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.pgb([126,954],0,44727808,190)
    {
    Name = "Vpu_R"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "1.2"
    }
   -Wire-([54,954],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([54,954],0,0,-1)
    {
    Name = "VpuR"
    }
   -Wire-([1062,342],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   -Wire-([432,378],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.ground([432,558],1,0,-1)
    {
    }
   -Wire-([1062,522],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   0.capacitor([1062,378],3,0,-1)
    {
    C = "500.0 [uF]"
    }
   0.pgb([360,1116],0,44620528,230)
    {
    Name = "Qvsc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([918,900],0,0,-1)
    {
    Name = "SrcP"
    }
   0.datalabel([918,846],0,0,-1)
    {
    Name = "SrcQ"
    }
   0.var([90,234],0,23776152,10)
    {
    Name = "VsetM"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "1.0"
    Units = "pu"
    Collect = "1"
    }
   -ControlPanel-([18,270],0)
    {
    Name = "Exciter Volts"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 18,270
    Extents = 0,0,72,126
    Slider(23776152)
    }
   0.var([216,1188],0,44686936,240)
    {
    Name = "Qrefse"
    Group = ""
    Display = "0"
    Max = "1.5"
    Min = "-1.5"
    Value = "0.1"
    Units = ""
    Collect = "1"
    }
   0.sumjct([360,1188],6,0,260)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.pi_ctlr([468,1188],0,0,280)
    {
    GP = "PgainQ"
    TI = "TconstQ"
    YHI = "1.0"
    YLO = "-1.0"
    YINIT = "0.0"
    Mthd = "0"
    INTR = "0"
    }
   0.pgb([612,1188],0,46130912,300)
    {
    Name = "ModIndex(mr)"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "1"
    }
   -Wire-([576,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,1188],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([432,1188],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([360,1152],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.pgb([306,1188],3,44781680,250)
    {
    Name = "Qrefr"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([414,1188],3,43294712,270)
    {
    Name = "QerrR"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([594,1188],0,0,-1)
    {
    Name = "mr"
    }
   -Sticky-([756,972],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 756,972,1044,1026
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Ac reactive power control for the sending end.
Signal \"mr\" modulates magnitude of PWM sin
 reference signal for sending end PWM control"
    }
   0.pgb([126,918],0,22750176,180)
    {
    Name = "SEndACVltg"
    Group = ""
    Display = "1"
    Scale = "0.0887"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "2"
    }
   -Wire-([72,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([306,234],0,0,-1)
    {
    Vertex="0,0;36,0;36,108"
    }
   -Sticky-([486,522],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 486,522,612,612
    Alignment = 0
    Style = 1
    Arrow = 16
    Color = 0,15792890
    Text = "\
10 MVAR RC Damped Capacitor.
Improved filtering may be needed."
    }
   0.sandhdefn([306,522],4,0,430)
    {
    Iand = "1"
    }
   -Wire-([180,378],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([342,522],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([270,522],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([306,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.timerdefn([54,576],4,0,150)
    {
    Timsw = "1.0 [s]"
    }
   0.datalabel([126,576],2,0,-1)
    {
    Name = "Src_Mc"
    }
   0.timerdefn([54,630],4,0,170)
    {
    Timsw = "2.0 [s]"
    }
   0.datalabel([126,630],2,0,-1)
    {
    Name = "Lock_Free"
    }
   0.datalabel([306,558],0,0,-1)
    {
    Name = "Lock_Free"
    }
   0.pgb([270,288],0,24036104,610)
    {
    Name = "If"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "2"
    }
   -Wire-([270,306],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([234,306],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.pgb([234,288],4,25004296,620)
    {
    Name = "Ef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-5"
    Max = "5"
    }
   0.pgb([180,378],4,23508464,570)
    {
    Name = "Te"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "2"
    }
   0.pgb([198,414],4,24388232,560)
    {
    Name = "Tm"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "2"
    }
   0.pgb([342,450],0,24385880,550)
    {
    Name = "TmO"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "2"
    }
   0.realpole([990,846],0,0,420)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "75"
    T = "0.02 [s]"
    Max = "50.0"
    Min = "-50.0"
    }
   -Wire-([918,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.realpole([990,900],0,0,440)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "75"
    T = "0.02 [s]"
    Max = "50.0"
    Min = "-50.0"
    }
   -Wire-([918,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([72,810],0,0,-1)
    {
    Name = "Rangle"
    }
   -Wire-([72,810],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([126,810],0,24436024,510)
    {
    Name = "M/CAngle"
    Group = ""
    Display = "1"
    Scale = "57.2958"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "80"
    }
   0.voltmeter([702,342],0,0,80)
    {
    Name = "Vb_a"
    }
   0.voltmeter([702,378],0,0,110)
    {
    Name = "Vc_b"
    }
   0.voltmeter([702,414],0,0,120)
    {
    Name = "Va_c"
    }
   -Wire-([666,450],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   -Wire-([702,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([1026,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1026,846],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([72,882],0,0,-1)
    {
    Name = "AngL"
    }
   -Wire-([72,882],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([126,882],0,24984264,490)
    {
    Name = "Load Angle"
    Group = ""
    Display = "1"
    Scale = "57.2958"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "100"
    }
   0.datalabel([72,846],0,0,-1)
    {
    Name = "AngR"
    }
   -Wire-([72,846],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([126,846],0,24433784,500)
    {
    Name = "Rotor Angle"
    Group = ""
    Display = "1"
    Scale = "57.2958"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "100"
    }
   0.datalabel([1062,846],0,0,-1)
    {
    Name = "McQ"
    }
   0.datalabel([36,180],0,0,-1)
    {
    Name = "McQ"
    }
   -Wire-([36,180],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.gain([90,180],0,0,380)
    {
    G = "0.00013"
    COM = "Gain"
    Dim = "1"
    }
   0.sumjct([162,234],0,0,390)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "1"
    E = "0"
    F = "0"
    G = "0"
    }
   -Wire-([126,180],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([162,198],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.var([630,1026],1,22961168,220)
    {
    Name = "QGain"
    Group = ""
    Display = "0"
    Max = "10"
    Min = "0.0"
    Value = "1.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([558,1062],0,0,-1)
    {
    Name = "TconstQ"
    }
   0.var([558,1026],1,23289120,210)
    {
    Name = "QTconst"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.1"
    Units = ""
    Collect = "1"
    }
   0.datalabel([630,1062],0,0,-1)
    {
    Name = "PgainQ"
    }
   0.pgb([126,990],0,44773720,200)
    {
    Name = "Pvsc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([72,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.realpole([540,1188],0,0,290)
    {
    Limit = "1"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.04 [s]"
    Max = "50.0"
    Min = "-50.0"
    }
   0.cable_interface([1152,234],0,0,-1)
    {
    Name = "Cable2"
    NCAB = "2"
    C1T = "1"
    C2T = "1"
    C3T = "1"
    C4T = "1"
    C5T = "1"
    C6T = "1"
    }
   -Wire-([1134,522],0,0,-1)
    {
    Vertex="0,0;0,-234"
    }
   -Sticky-([54,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,468,180,522
    Alignment = 0
    Style = 1
    Arrow = 32
    Color = 0,15792890
    Text = "75 MVA Synchronous generator with solid state exciter"
    }
   -ControlPanel-([522,900],0)
    {
    Name = "Reac.Pwr Cntrl"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 522,900
    Extents = 0,0,144,126
    Slider(23289120)
    Slider(22961168)
    }
   -Sticky-([540,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 540,1080,630,1116
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "P-I controller gains"
    }
   -Sticky-([288,1026],0)
    {
    Name = ""
    Font = 1
    Bounds = 288,1026,468,1062
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = " SE REACTIVE POWER CONTROLLER"
    }
   -Sticky-([180,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,612,396,648
    Alignment = 0
    Style = 1
    Arrow = 16
    Color = 0,15792890
    Text = "Synchronous generator initializing timer signals"
    }
   0.filter([432,522],5,0,-1)
    {
    Cnfg = "0"
    Q = "100.0"
    Fo = "60.0 [Hz]"
    F = "300.0 [Hz]"
    MVAR = "100.0 [MVAR]"
    Volt = "132.79 [kV]"
    R = "0.5 [ohm]"
    L = "0.0 [H]"
    C = "139.0 [uF]"
    }
   0.sync_machine([270,378],0,0,400)
    {
    Name = "Gen2"
    Nqaxw = "1"
    Cnfg = "0"
    MM = "1"
    CfRa = "1"
    MSat = "0"
    icTyp = "0"
    Iscl = "1"
    View = "1"
    itrfa = "0"
    izro = "0"
    Icsp = "0"
    Icmp = "0"
    Immd = "0"
    Ifmlt = "0"
    Term = "0"
    Ts = "0.02 [s]"
    Iexc = "0"
    Igov = "1"
    Ospd = "0"
    machsw = "Src_Mc"
    Enab = "Lock_Free"
    npadjs = "0"
    pset = "0.0 [MW]"
    nftrsw = "0"
    hmult = "1.0"
    sdmftr = "1.0"
    sdmspd = "1.0"
    npadjm = "0"
    fldmlt = "1.0"
    nfldsw = "0"
    Vbase = "7.97 [kV]"
    Ibase = "3.136 [kA]"
    OMO = "376.99112 [rad/s]"
    H = "3.17 [s]"
    D = "0.0 [pu]"
    RNeut = "1.0E5 [pu]"
    XNeut = "0 [pu]"
    Ri = "300.0 [pu]"
    NOM = "1.0"
    Rs1 = "0.0025 [pu]"
    XS1 = "0.14 [pu]"
    XMD0 = "1.66 [pu]"
    R2D = "0.00043 [pu]"
    X2D = "0.2004 [pu]"
    R3D = "0.0051 [pu]"
    X3D = "0.0437 [pu]"
    X230 = "0.0 [pu]"
    XMQ = "0.91 [pu]"
    R2Q = "0.00842 [pu]"
    X2Q = "0.106 [pu]"
    R3Q = "8.1942E-03 [pu]"
    X3Q = "9.4199E-02 [pu]"
    X231 = "0.0 [pu]"
    Ra = "0.002 [pu]"
    Ta = "0.332 [s]"
    Xp = "0.120 [pu]"
    Xd = "1.05 [pu]"
    Xd' = "0.300 [pu]"
    Tdo' = "7.6 [s]"
    Xd'' = "0.205 [pu]"
    Tdo'' = "0.03 [s]"
    Gfld = "1.0E+2 [pu]"
    Xkf = "0.0 [pu]"
    Xq = "0.686 [pu]"
    Xq' = "0.228 [pu]"
    Tqo' = "0.85 [s]"
    Xq'' = "0.205 [pu]"
    Tqo'' = "0.03 [s]"
    AGFC = "1.0"
    X1 = "0.0"
    Y1 = "0.0 [pu]"
    X2 = "0.5"
    Y2 = "0.5 [pu]"
    X3 = "0.8"
    Y3 = "0.79 [pu]"
    X4 = "1.0"
    Y4 = "0.947 [pu]"
    X5 = "1.2"
    Y5 = "1.076 [pu]"
    X6 = "1.5"
    Y6 = "1.2 [pu]"
    X7 = "1.8"
    Y7 = "1.26 [pu]"
    X8 = "2.2"
    Y8 = "1.32 [pu]"
    X9 = "3.2"
    Y9 = "1.53 [pu]"
    X10 = "4.2"
    Y10 = "1.74 [pu]"
    VT = "1.0 [pu]"
    Pheta = "0.5 [rad]"
    Trmpv = "0.05 [s]"
    Sysfl = "100.0 [pu]"
    Ptcon = "0.2 [s]"
    P0 = "0.0 [MW]"
    Q0 = "0.0 [MVAR]"
    Theti = "3.141592 [rad]"
    Idi = "0.0 [pu]"
    Iqi = "0.0 [pu]"
    Ifi = "0.0 [pu]"
    Spdi = "1.0 [pu]"
    POut = "SrcP"
    QOut = "SrcQ"
    Vneut = ""
    Cneut = ""
    Lang = "AngL"
    Theta = "AngR"
    Wang = "Rangle"
    Tesmt = "Testdy"
    PQscl = "0"
    InExc = "InitEx"
    InGov = "InitGv"
    Mon1 = "1"
    Chn1 = ""
    Mon2 = "1"
    Chn2 = ""
    Mon3 = "1"
    Chn3 = ""
    Mon4 = "1"
    Chn4 = ""
    Mon5 = "1"
    Chn5 = ""
    Mon6 = "1"
    Chn6 = ""
    }
   0.nodeloop([342,378],0,0,70)
    {
    View = "1"
    }
   0.exc_scrx([270,234],0,0,410)
    {
    T1 = "0.02 [s]"
    Ta = "0.5 [s]"
    Tb = "0.2 [s]"
    Te = "0.02 [s]"
    K = "40 [pu]"
    Emax = "5 [pu]"
    Emin = "-5 [pu]"
    Vbase = "7.967 [kV]"
    Ibase = "3.17 [kA]"
    Rrev = "15000 [ohm]"
    IBSF = "1"
    IRef = "0"
    Enab = "1"
    IExst = "0"
    View = "1"
    }
   0.xfmr-3p2w([540,378],0,0,100)
    {
    Name = ""
    Tmva = "100.0 [MVA]"
    f = "60.0 [Hz]"
    YD1 = "0"
    YD2 = "1"
    Lead = "2"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "13.8 [kV]"
    V2 = "62.5[kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "0.2 [%]"
    ILA1 = "C1a"
    ILB1 = "C1b"
    ILC1 = "C1c"
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([522,414],1,0,-1)
    {
    }
   -Wire-([612,414],0,0,-1)
    {
    Vertex="0,0;360,0"
    }
   -Wire-([612,378],0,0,-1)
    {
    Vertex="0,0;252,0"
    }
   -Wire-([612,342],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.breakout([576,378],0,0,-1)
    {
    Dis = "0"
    }
   -Sticky-([36,1098],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,1098,198,1152
    Alignment = 0
    Style = 1
    Arrow = 130
    Color = 0,15792890
    Text = "\
Qrefse:
   Sending end reactive
   power order (pu)"
    }
   0.pgb([432,1440],0,24945008,360)
    {
    Name = "dcCurrent Rec"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "300"
    }
   0.pgb([504,1404],3,24503456,450)
    {
    Name = "Prec"
    Group = ""
    Display = "1"
    Scale = "0.01"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "2"
    }
   0.datalabel([216,1368],0,0,-1)
    {
    Name = "dcVltg"
    }
   0.mult([414,1404],0,0,370)
    {
    }
   0.realpole([288,1440],0,0,350)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.realpole([288,1368],0,0,310)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.02 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([216,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,1404],0,0,-1)
    {
    Vertex="0,0;450,0;450,-126"
    }
   0.datalabel([486,1404],4,0,-1)
    {
    Name = "Pdc"
    }
   0.pgb([414,1368],0,23084328,320)
    {
    Name = "dcVoltage Rec"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "160"
    }
   -Wire-([216,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,1440],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([324,1368],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([378,1404],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.pgb([306,1404],0,24104232,330)
    {
    Name = "dclineRec"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3"
    Max = "4"
    }
   -Wire-([234,1440],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([234,1404],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Sticky-([234,1494],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,1494,450,1530
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Sending end (rectifier) dc voltage, 
current and power measurement."
    }
   0.radiolink([144,1440],4,0,340)
    {
    Source = "SE"
    Name = "DCCurrent"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   -Wire-([216,1440],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.datalabel([216,1440],4,0,-1)
    {
    Name = "dcCur"
    }
   -ControlPanel-([72,1206],0)
    {
    Name = "SE Q Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 72,1206
    Extents = 0,0,72,126
    Slider(44686936)
    }
   -Sticky-([54,0],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,0,1170,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
VSC TRANSMISSION WITH AC TRANSMISSION CHARACTERISTICS
Sending End Subpage"
    }
   0.multimeter([468,378],0,0,90)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "1"
    MeasQ = "1"
    RMS = "1"
    MeasPh = "0"
    S = "100.0 [MVA]"
    BaseV = "13.8 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "VRec"
    P = "Pvsc"
    Q = "Qvsc"
    Vrms = "VpuR"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datalabel([72,990],0,0,-1)
    {
    Name = "Pvsc"
    }
   0.datalabel([360,1116],2,0,-1)
    {
    Name = "Qvsc"
    }
   .SECtrl([954,1242],0,0,460)
    {
    }
   0.datalabel([1008,1152],0,0,-1)
    {
    Name = "Rg1"
    }
   0.datalabel([1008,1188],0,0,-1)
    {
    Name = "Rg2"
    }
   0.datalabel([1008,1224],0,0,-1)
    {
    Name = "Rg3"
    }
   0.datalabel([1008,1260],0,0,-1)
    {
    Name = "Rg4"
    }
   0.datalabel([1008,1296],0,0,-1)
    {
    Name = "Rg5"
    }
   0.datalabel([1008,1332],0,0,-1)
    {
    Name = "Rg6"
    }
   0.datalabel([900,1242],0,0,-1)
    {
    Name = "mr"
    }
   0.datalabel([900,1278],4,0,-1)
    {
    Name = "Pdc"
    }
   0.datalabel([900,1206],4,0,-1)
    {
    Name = "VRec"
    }
   0.datalabel([72,918],0,0,-1)
    {
    Name = "VRec"
    }
   -Wire-([594,1188],0,0,-1)
    {
    Vertex="0,0;0,54;306,54"
    }
   -Wire-([90,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([90,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Divider-([18,738],0)
    {
    Size(1152,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 1
    }
   0.voltmeter([1062,288],3,0,40)
    {
    Name = "dcVltg"
    }
   -Wire-([1098,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144362028
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,176,[597,467],100)
   {
   -Sticky-([18,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 18,72,576,324
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
EXAMPLE CASE: 
VSC Transmission with AC transmission characteristics based on a simple 6-pulse STATCOM example provides up to 75 MW power to the ac receiving end system, DC voltage - 110kV

- Rectifier
Controls power as a function of phase angle difference between sending end and receiving end AC voltages, Controls reactive power at the sending end bus.  
Note: Sending end AC voltage controlled by exciter of the generator. PWM with carrier frequency up to 33 times fundamental.
                         
- Inverter
Controls AC voltage - magnitude and also DC voltage.  Uses PWM with carrier frequency up to 33 times fundamental.
 "
    }
   -Cable-([342,432],0,116283208,-1)
    {
    Name = "Cable2"
    Date = 1144362029
    Freq = "0 [Hz]"
    Length = "100.0 [km]"
    Dim = 2
    Mode = 0
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,51,[597,467],100)
     {
     0.Line_Ground([288,288],0,116284520,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Cable_Coax([288,558],0,116285512,-1)
      {
      CABNUM = "1"
      Y = "1 [m]"
      X = "0 [m]"
      LL = "3"
      LC = "1"
      SHRad = "1"
      CONNAM1 = "Conductor"
      CONNAM2 = "Sheath"
      CONNAM3 = "Armour"
      CONNAM4 = "Outside Cond."
      R1 = "0.0 [m]"
      R2 = "0.0104 [m]"
      RHOC = "2.82e-8 [ohm*m]"
      PERMC = "1"
      R3 = ".016 [m]"
      EPS1 = "4.1"
      PERM1 = "1"
      R4 = ".0205 [m]"
      RHOS = "1.86e-8 [ohm*m]"
      PERMS = "1"
      R5 = ".0215 [m]"
      EPS2 = "2.3"
      PERM2 = "1"
      R6 = ".0583 [m]"
      RHOA = "1.8e-7 [ohm*m]"
      PERMA = "400"
      R7 = ".0635 [m]"
      EPS3 = "1.0"
      PERM3 = "1"
      R8 = ".07 [m]"
      RHOO = "1.8e-7 [ohm*m]"
      PERMO = "400"
      R9 = ".08 [m]"
      EPS4 = "1.0"
      PERM4 = "1"
      }
     0.Cable_Coax([738,558],0,116288280,-1)
      {
      CABNUM = "2"
      Y = "1 [m]"
      X = "0.4 [m]"
      LL = "3"
      LC = "1"
      SHRad = "1"
      CONNAM1 = "Conductor"
      CONNAM2 = "Sheath"
      CONNAM3 = "Armour"
      CONNAM4 = "Outside Cond."
      R1 = "0.0 [m]"
      R2 = "0.0104 [m]"
      RHOC = "2.82e-8 [ohm*m]"
      PERMC = "1"
      R3 = ".016 [m]"
      EPS1 = "4.1"
      PERM1 = "1"
      R4 = ".0205 [m]"
      RHOS = "1.86e-8 [ohm*m]"
      PERMS = "1"
      R5 = ".0215 [m]"
      EPS2 = "2.3"
      PERM2 = "1"
      R6 = ".0583 [m]"
      RHOA = "1.8e-7 [ohm*m]"
      PERMA = "400"
      R7 = ".0635 [m]"
      EPS3 = "1.0"
      PERM3 = "1"
      R8 = ".07 [m]"
      RHOO = "1.8e-7 [ohm*m]"
      PERMO = "400"
      R9 = ".08 [m]"
      EPS4 = "1.0"
      PERM4 = "1"
      }
     0.Line_FrePhase_Options([612,180],0,116295096,-1)
      {
      Interp1 = "1"
      Output = "1"
      Inflen = "0"
      FS = "0.001 [Hz]"
      FE = "1.0E5 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "1"
      W2 = "1"
      W3 = "1"
      }
     }
    }
   .SE([180,468],0,0,10)
    {
    }
   .RE([612,468],0,0,20)
    {
    }
   -Plot-([54,720],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,522,828]
    Posn = [54,720]
    Icon = [-1,-1]
    Extents = 0,0,522,828
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,522,192],"deg")
     {
     Options = 0
     Units = ""
     Curve(24436024,"M/CAngle",0,,,)
     }
    Graph([0,192],[0,0,522,191],"deg")
     {
     Options = 0
     Units = ""
     Curve(24776368,"DA",0,,,)
     }
    Graph([0,383],[0,0,522,191],"Reactive Power")
     {
     Options = 0
     Units = ""
     Curve(25124592,"QpowerR",0,,,)
     Curve(24509640,"QpowerI",0,,,)
     }
    Graph([0,574],[0,0,522,191],"Power")
     {
     Options = 0
     Units = ""
     Curve(25122768,"PowerR",0,,,)
     Curve(50786688,"PowerI",0,,,)
     }
    }
   -Plot-([630,720],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,522,828]
    Posn = [630,720]
    Icon = [36,504]
    Extents = 0,0,522,828
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,522,192],"Voltage")
     {
     Options = 0
     Units = ""
     Curve(23084328,"dcVoltage Rec",0,,,)
     Curve(25116208,"dcVoltage Inv",0,,,)
     }
    Graph([0,192],[0,0,522,191],"Voltage")
     {
     Options = 0
     Units = ""
     Curve(44727808,"Vpu_R",0,,,)
     Curve(24778136,"Vpu_I",0,,,)
     }
    Graph([0,383],[0,0,522,191],"DC Current")
     {
     Options = 0
     Units = ""
     Curve(24104232,"dclineRec",0,,,)
     Curve(46381720,"dclineInv",0,,,)
     }
    Graph([0,574],[0,0,522,191],"")
     {
     Options = 0
     Units = ""
     Curve(46130912,"ModIndex(mr)",0,,,)
     Curve(24540376,"ModIndex(mi)",0,,,)
     }
    }
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,18,1170,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "VSC TRANSMISSION WITH AC TRANSMISSION CHARACTERISTICS"
    }
   -Sticky-([810,306],0)
    {
    Name = ""
    Font = 1
    Bounds = 810,306,1188,666
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
MODES OF CONTROL
     Because PWM is used, there are two modes of control which can be independently applied at each converter. The modes of control used in this model are as follows:

1. Ac voltage control at the sending end is achieved by the exciter of the 75 MVA synchronous generator.

2. Power flow is achieved by controlling the phase angle of the ac side voltage of  the sending end converter.

3. Reactive power generated by the sending end converter is held to a low value by adjusting the magnitude of  the voltage on the ac side of the sending end converter.

4. The dc voltage is controlled by adjusting the phase angle of the ac side voltage of the receiving end converter.

5. The ac voltage magnitude at the receiving end ac bus is controlled by the magnitude of the voltage at the ac side of the receiving end converter."
    }
   -Sticky-([630,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 630,72,1170,288
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
CASE START-UP INSTRUCTIONS
Run case to 2.0 seconds and take a SNAPSHOT at 2.0 seconds.

  -  Generator operates as a voltage source at its terminals for the period 0 to 1 second during the start-up.  After 1.0 second, the generator operates as a synchronus machine with its terminal voltage determined by its exciter.  However, the rotor is locked until 2 seconds.

 -  The Voltage Source Converters de-block at 0.2 seconds at each end simultaneously.

-   The 1L-G fault is applied at the ac system at receiving end at 2.1 seconds or 0.1 second after the SNAPSHOT is taken.

"
    }
   }
  }
 }

